rule Win32_PUA_Domaiq : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DOMAIQ"
        description         = "Yara rule that detects Domaiq potentially unwanted application."

        tc_detection_type   = "PUA"
        tc_detection_name   = "Domaiq"
        tc_detection_factor = 1

    strings:
        $payload="PEFxdWlFbXBpZXphRWxQYXlsb2FkPg"

        $NSIS_CheckIntegrity = { 
            57 53 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 ?? 6A 1C 8D 45 
            D8 53 50 E8 ?? ?? ?? ?? 8B 45 D8 A9 F0 FF FF FF 75 ?? 81 7D DC EF BE AD DE 75 ?? 81 
            7D E8 49 6E 73 74 75 ?? 81 7D E4 73 6F 66 74 75 ?? 81 7D E0 4E 75 6C 6C 75 ?? 09 45 
            08 8B 45 08 8B 0D ?? ?? ?? ?? 83 E0 02 09 05 ?? ?? ?? ?? 8B 45 F0 3B C6 89 0D ?? ?? 
            ?? ?? 0F 8F ?? ?? ?? ?? F6 45 08 08 75 ?? F6 45 08 04 75
        }

        $NSIS_ErrorPart = {
            81 EC ?? ?? ?? ?? 53 55 56 33 DB 57 89 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 33 F6 C6 44 
            24 ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 6A 
            ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 53 8D 44 24 ?? 68 ?? ?? ?? ?? 50 53 
            68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? BF ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 80 3D ?? ?? ?? 
            ?? ?? A3 ?? ?? ?? ?? 8B C7 75
        }

        $UPX_Decompression = {
            8A 06 46 88 07 47 01 DB 75 ?? 8B 1E 83 EE ?? 11 DB 72 ?? B8 ?? ?? ?? ?? 01 DB 75 ?? 
            8B 1E 83 EE ?? 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE ?? 11 DB 72 ?? 48 01 DB 75
        }

        $UPX_Encrypting = {
            31 C0 8A 07 30 D8 04 ?? 2C ?? 88 07 47 39 CF 75
        }

        $dumping_functionv2014 = {
            55 8B EC 83 EC ?? 56 68 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 
            ?? ?? ?? ?? 56 6A ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            89 45 ?? 85 C0 74 ?? 56 6A ?? FF 15 ?? ?? ?? ?? 8B F0 89 75 ?? 85 F6 74 ?? 8B 45 ?? 
            53 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 
            56 6A ?? 6A ?? 8B D8 6A ?? 53 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 57 6A ?? 6A ?? 6A 
            ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B 55 ?? 51 8B F8 52 57 E8 ?? ?? ?? ?? 83 C4 
            ?? 57 FF 15 ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? FF D6 53 FF D6 5F 5B 5E 8B E5 5D C3 
        }

        $dumping_functionMidVersion = {
            55 8B EC 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 68 ?? ?? ?? ?? 33 
            DB BE ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 45 ?? 89 75 ?? 89 5D ?? 88 5D ?? FF 15 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 8B CF 8D 41 ?? 8A 11 41 3A 
            D3 75 ?? 2B C8 51 57 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 
            83 EC ?? 8B CC 89 65 ?? 6A ?? 89 71 ?? 89 59 ?? 68 ?? ?? ?? ?? 88 59 ?? E8 ?? ?? ?? 
            ?? 83 EC ?? 8B CC 89 65 ?? 6A ?? 53 8D 55 ?? 89 71 ?? 89 59 ?? 52 88 59 ?? E8 ?? ?? 
            ?? ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B CC 89 65 ?? 6A ?? 89 71 ?? 89 59 ?? 68 ?? ?? 
            ?? ?? 88 59 ?? E8 ?? ?? ?? ?? 83 EC ?? 8B CC 89 65 ?? 6A ?? 53 8D 45 ?? 89 71 ?? 89 
            59 ?? 50 88 59 ?? E8 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B CC 89 65 ?? 6A ?? 
            89 71 ?? 89 59 ?? 68 ?? ?? ?? ?? 88 59 ?? E8 ?? ?? ?? ?? 83 EC ?? 8B CC 89 65 ?? 6A 
            ?? 53 8D 55 ?? 89 71 ?? 89 59 ?? 52 88 59 ?? E8 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 8B C4 89 65 ?? 68 ?? ?? ?? ?? 8D 4D ?? 51 50 E8 ?? ?? ?? ?? 83 C4 ?? E8 ?? ?? 
            ?? ?? 8B 7D ?? BE ?? ?? ?? ?? 83 C4 ?? 39 75 ?? 73 ?? 8D 7D ?? 68 ?? ?? ?? ?? 8D 55 
            ?? 52 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 39 70 ?? 72 ?? 8B 40 ?? EB ?? 83 C0 ?? 8B 
            4D ?? 57 51 50 E8 ?? ?? ?? ?? 83 C4 ?? 39 75 ?? 72 ?? 8B 55 ?? 52 E8 ?? ?? ?? ?? 83 
            C4 ?? 39 75 ?? 72 ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 5F 5E 33 CD 33 C0 
            5B E8 ?? ?? ?? ?? 8B E5 5D C2
        }

        $dumping_functionE = {
            52 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 5? FF 15 ?? ?? ?? ?? 
            89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 6A ?? FF 15 ?? 
            ?? ?? ?? 89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 68 ?? 
            ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 77 ?? 83 BD ?? ?? ?? ?? ?? 75 ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 68 ?? ?? 
            ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? 
            ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 
            8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 
            15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 51 8B CC 89 A5 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? E8
        }

        $dumping_functionP = {
            50 57 56 FF 15 ?? ?? ?? ?? 8B F8 57 56 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 57 56 
            89 45 ?? FF 15 ?? ?? ?? ?? 89 45 ?? 8D 45 ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BF 
            ?? ?? ?? ?? 57 56 68 ?? ?? ?? ?? 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 6A 
            ?? 56 56 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 56 8B D8 8D 45 ?? 50 FF 75 ?? 89 75 ?? 
            FF 75 ?? 53 FF 15 ?? ?? ?? ?? 53 FF 15
        }

        $dumping_functionB= {
            52 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 
            85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? BE ?? ?? ?? ?? 8D BD ?? 
            ?? ?? ?? F3 A5 A4 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 89 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? F3 A5 A4 
            6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 8B 95 
            ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 95 ?? 
            ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 51 8B CC 89 A5 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? E8
        }

        $dumping_function111 = {
            68 ?? ?? ?? ?? 8D 55 ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 45 ?? 50 8D 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 39 58 ?? 72 ?? 8B 40 ?? EB 
            ?? 83 C0 ?? 50 6A ?? 8D 4D ?? E8 ?? ?? ?? ?? 39 5D ?? 72 ?? 8B 55 ?? 52 E8 ?? ?? ?? 
            ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 8D 4D ?? 51 E8
        }

        $dumping_function2 = {
            55 8B EC 51 53 8B 5D ?? 56 68 ?? ?? ?? ?? 8D 45 ?? 53 50 33 F6 E8 ?? ?? ?? ?? 8B 4D 
            ?? 68 ?? ?? ?? ?? 51 8D 55 ?? 52 E8 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 
            83 F8 ?? 74 ?? 57 8B 7D ?? 0F BE 14 3E 8B 4D ?? 51 33 D0 52 E8 ?? ?? ?? ?? 8B C7 83 
            C4 ?? 8D 50 ?? 8D A4 24 ?? ?? ?? ?? 8A 08 40 84 C9 75 ?? 2B C2 8D 4E ?? 8B D1 2B D0 
            8B 45 ?? F7 DA 1B D2 23 D1 50 8B F2 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 ?? 5F 8B 4D 
            ?? 51 E8 ?? ?? ?? ?? 8B 55 ?? 52 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 5E 5B 8B 
            E5 5D C2
        }

        $lib_loader = {
            68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 33 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 A3 ?? ?? 
            ?? ?? FF D6 33 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 33 05 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 33 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 
        }

        $exception1 = {
            B8 ?? ?? ?? ?? 50 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 33 C0 89 08 
        }

        $exception2 = {
            55 53 51 57 56 52 8D 98 ?? ?? ?? ?? 8B 53 ?? 52 8B E8 6A ?? 68 ?? ?? ?? ?? FF 73 ?? 
            6A ?? 8B 4B ?? 03 CA 8B 01 FF D0 
        }

        $exceptionallock = {
            B8 ?? ?? ?? ?? 8D 88 ?? ?? ?? ?? 89 41 ?? 8B 54 24 ?? 8B 52 ?? C6 02 ?? 83 C2 ?? 
            2B CA 89 4A ?? 33 C0 C3 
        }

    condition:

        uint16(0) == 0x5A4D and 
        $payload and
        (
            $NSIS_CheckIntegrity or
            ($UPX_Decompression and $UPX_Encrypting) or
            $NSIS_ErrorPart or
            $dumping_functionv2014 or
            $dumping_functionMidVersion or
            ($exception1 and $exception2 and $exceptionallock) or
            $dumping_functionP or
            $dumping_functionE or
            $dumping_functionB or
            $dumping_function111 or
            $dumping_function2 or
            $lib_loader
        )
}